#!/usr/bin/perl

# c4lj2doaj.pl - query code4lib journal (wordpress) database and create doajaxml

# Eric Lease Morgan <emorgan@nd.edu>
# May 24, 2008 - second cut

# require
use lib '../lib';
use C4LJ::Article;
use strict;

# initialize
my $records = '';
my $issue = $ARGV[ 0 ];

# (weak) sanity check
if ( $issue !~ /\d+/ ) {

	print "Usage: $0 n where n is an integer\n";
	exit;
	
}

# process each article
foreach my $article ( C4LJ::Article->get_articles( issue => $issue )) {

	# slurp up the template and process the macros
	my $record = &template;
	$record =~ s/##TITLE##/&escape_entities($article->title)/e;
	$record =~ s/##ABSTRACT##/&escape_entities($article->abstract)/e;
	$record =~ s/##AUTHOR##/&escape_entities($article->author)/e;
	$record =~ s/##URL##/&escape_entities($article->url)/e;
	$record =~ s/##DATE##/&escape_entities($article->date)/e;
	$record =~ s/##ISSUE##/&escape_entities($article->issue)/e;
	
	# add the records to the list of records
	$records .= $record;
	
}

# done
print <<XML;
<?xml version="1.0" encoding="UTF-8"?>
<records>
$records</records>
XML


sub template {

	return <<EOT;
  <record>
    <language>eng</language>
    <publisher>Code4Lib</publisher>
    <journalTitle>Code4Lib Journal</journalTitle>
    <issn>19405758</issn>
    <publicationDate>##DATE##</publicationDate>
    <issue>##ISSUE##</issue>
    <documentType>article</documentType>
    <title language="eng">##TITLE##</title>
    <authors>
      <author>
        <name>##AUTHOR##</name>
      </author>
    </authors>
    <abstract language="eng">##ABSTRACT##</abstract>
    <fullTextUrl format="html">##URL##</fullTextUrl>
  </record>
EOT

}

sub escape_entities {

	# get the input
	my $s = shift;
	
	# escape
	$s =~ s/&/&amp;/g;
	$s =~ s/</&lt;/g;
	$s =~ s/>/&gt;/g;
	$s =~ s/"/&quot;/g;
	$s =~ s/'/&apos;/g;

	# done
	return $s;
	
}

