#!/usr/bin/perl

# mods.cgi - simple CGI interface to a swish-e index of MODS files

# Eric Lease Morgan <eric_morgan@infomotions.com>

# July 7, 2004 - Getting ready for LAMP


# define a few global constants; configure
my $AUTHOR    = 'Eric Lease Morgan';
my $EMAIL     = 'eric_morgan@infomotions.com';
my $INDEX     = 'mods.idx';
my $PAGETITLE = 'MODS Search';


###############################################################################################
# no configuration should be necessary below this line, unless you want to configure the output


# define the necessary modules
use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser);
use strict;
use SWISH::API;

# declare/initialize a few global variables
my $number_of_hits = '';
my $hit_list       = '';
my $html           = '';

# initalize CGI I/O
my $input  = new CGI;
my $output = new CGI("");

# start the output
$html  = $output->header;
$html .= $output->start_html(-title => $PAGETITLE);
$html .= &header;
	                             
# get the command
my $cmd = $input->param('cmd');

# branch according to the command
if (! $cmd ) {

	# simply get the home page
	$html .= &home;

}

elsif ( $cmd eq 'help' ) {

	# simply disply the search help
	$html .= &help;
	
}

elsif ( $cmd eq 'about' ) {

	# simply disply the about text -- the documentation
	$html .= &about;
	
}

elsif ( $cmd eq 'search' ) {

	# check for query
	if (! $input->param('query')) {
	
		# error
		$html .= '<p><b>Opps!</b> No query was supplied.</p>';
		
		# quit
		&gracefulExit;
	
	}
		
	# search the index
	&search;
	
}

else {

	# error; unknown command
	$html .= "<p><b>Oops!</b> Unknown value for cmd ($cmd). Call <a href='mailto:$EMAIL'>$AUTHOR</a>.</p>";

}

# quit
&gracefulExit;


#############
# subroutines


# display the output and exit the application
sub gracefulExit {

	# get the search form
	my $form = &form;
	
	# add the footer to the output
	$html .= &footer . '</body></html>';
		
	# proces each macro
	$html =~ s/##NUMBEROFHITS##/$number_of_hits/g;
	$html =~ s/##SEARCHFORM##/$form/g;
	$html =~ s/##HITLIST##/$hit_list/g;
	$html =~ s/##QUERY##/$input->param('query')/eg;
		
	# display the html, finally
	print $html;
	
	# quit, whew!
	exit;
	
}


# the heart of the matter
sub search {

	# get the result page
	$html .= &results;

	# open the index
	my $swish = SWISH::API->new($INDEX);
	
	# create a search object
	my $search = $swish->New_Search_Object;
	
	# set the sort order
	$search->SetSort('title');
	
	# search
	my $results = $search->Execute($input->param('query'));
	
	# get the number of titles found
	$number_of_hits = $results->Hits;
			
	# initalize the hit list
	$hit_list .= '<ol>';
	
	# process each hit
	while (my $result = $results->NextResult) {
		
		# get the results
		my $detail    = $result->Property ('swishdocpath');
		my $title     = $result->Property ('title');
		my $author    = $result->Property ('namePart');
		my $extent    = $result->Property ('extent');
		my $note      = $result->Property ('note');
		my $topic     = $result->Property ('topic');
		my $publisher = $result->Property ('publisher');
		my $date      = $result->Property ('dateIssued');
									
		$hit_list .= "<li>$title (<a href='$detail'>full record</a>)
		              <ul>
		                <li><small><b>author</b>: $author</small></li>
		                <li><small><b>extent</b>: $extent</small></li>
		                <li><small><b>note</b>: $note</small></li>
		                <li><small><b>topic</b>: $topic</small></li>
		                <li><small><b>publisher</b>: $publisher</small></li>
		                <li><small><b>date</b>: $date</small></li>
		              </ul>
		              <br />
		              </li>";
					
	}
	
	# finish the hit list
	$hit_list .= '</ol>';

}
	

#######################################################
# edit these subroutines to change the output's display


sub form {

	# return a search form
	my $form ="<form action='" . $input->url . "' method='get'><input type='hidden' name='cmd' value='search'/><input name='query' value='##QUERY##' /><br />";
	$form .= "<input type='submit' value='Go' /></form>";

	return $form;
	
}


sub about {

	# return an about text
	return <<EOF
<h1>About</h1>

<p>This is an CGI interface to a swish-e index of MODS files.</p>
EOF

}


sub home {

	# define the root url
	my $root = $input->url;
	
	# display the home page
	return <<EOF
<h1>$PAGETITLE</h1>
<p>This is a CGI interface to a swish-e index of MODS files. See the <a href='$root?cmd=about'>About</a> text for more detail.</p>
EOF

}


sub results {

	# return a search results template
	return <<EOF
<h1>Search results</h1>
<p>Your search (##QUERY##) found ##NUMBEROFHITS## title(s).</p>

##HITLIST##

EOF

}


sub help {
	
	# display a help text
	return <<EOF
<h1>Search tips</h1>
<p>The search engine supports any combination of Boolean logic, nested queries, phrase searching, field searching, freetext searching, or right-hand trunctaion. Queries are case-insensitive. Examples include:</p>
<center>
	<table border='0'>
		<tr>
			<td align='right' bgcolor='silver'><b>Types</b></td>
			<td bgcolor='silver'><b>Examples</b></td>
		</tr>
		<tr>
			<td align='right'>simple (freetext):</td>
			<td>red</td>
		</tr>
		<tr>
			<td align='right'>right-hand truncation:</td>
			<td>red*</td>
		</tr>
		<tr>
			<td align='right'>Boolean and:</td>
			<td>red and blue</td>
		</tr>
		<tr>
			<td align='right'>Boolean and:</td>
			<td>red blue</td>
		</tr>
		<tr>
			<td align='right'>Boolean or:</td>
			<td>red or blue</td>
		</tr>
		<tr>
			<td align='right'>Boolean not:</td>
			<td>red not blue</td>
		</tr>
		<tr>
			<td align='right'>nested:</td>
			<td>(red or blue) and green</td>
		</tr>
		<tr>
			<td align='right'>phrase:</td>
			<td>"light red"</td>
		</tr>
		<tr>
			<td align='right'>field:</td>
			<td>title = red</td>
		</tr>
	</table>
</center>

EOF

}


sub header {

	# define root url
	my $root = $input->url;
		
	# return a header
	return <<EOF
<table cellpadding='10'>

	<tr valign='top'>
		<td valign='top' align='right' bgcolor='silver'>
			<h2><a href='$root'>$PAGETITLE</a></h2>
			
			##SEARCHFORM##
			
			<a href='$root?cmd=help'>Tips</a><br />
			<a href='$root?cmd=about'>About</a><br />
			
		</td>
		<td>

EOF

}


sub footer {

	# define root url
	my $root = $input->url;
	
	# display a footer
	return <<EOF
		<hr />
		<p>
			<small>
				Author: $AUTHOR (<a href='mailto:$EMAIL'>$EMAIL</a>)<br />
				URL: <a href='$root'>$root</a>
			</small> 
		</p>
		</td>
	</tr>
</table>

EOF
	
}

