#!/usr/bin/perl

# xsltproc.pl - tranform XML file using an XSLT file

# Eric Lease Morgan <eric_morgan@infomotions.com>

# July 7, 2004 - Getting ready for LAMP 'n Monterey


######################################################
# no configuration should be necessary below this line

# require the necessary modules
use strict;
use XML::LibXML;
use XML::LibXSLT;

# get input
my $xslt_file = $ARGV[0];
my $xml_file  = $ARGV[1];

# check for input
if (! $xslt_file || ! $xml_file) {

	print "Usage: $0 stylesheet source-file\n";
	exit;

}

# initialize
my $parser = XML::LibXML->new;
my $xslt   = XML::LibXSLT->new;

# parse the input files
my $style = $parser->parse_file($xslt_file);
my $doc   = $parser->parse_file($xml_file);

# validate stylesheet
my $stylesheet = $xslt->parse_stylesheet($style);

# transform the source file
my $results = $stylesheet->transform($doc);

# print the result to STDOUT
print $stylesheet->output_string($results);

# done
exit;
