<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
	
	<xsl:output 
		method="xml"
		omit-xml-declaration="no"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />
		
	<xsl:param name="sortby" select="name"/>
		
	<!-- pets -->
	<xsl:template match="pets">

		<html>
			<head>
				<title>Pets</title>
			</head>
			<body style="margin: 5%">
				<h1>Pets</h1>
				<ul>
					<li>Total number of pets: <xsl:value-of select="count(pet)"/></li>
					<li>Average age of pets: <xsl:value-of select="sum(pet/age) div count(pet)"/></li>
				</ul>
				<p>Pets sorted by: <xsl:value-of select="$sortby"/></p>
				<table>
					<thead>
						<tr>
							<td style="text-align: right; font-weight: bold">Name</td>
							<td style="text-align: right; font-weight: bold">Age</td>
							<td style="font-weight: bold">Type</td>
							<td style="font-weight: bold">Color</td>
						</tr>
					</thead>
					<xsl:apply-templates select="pet">
						<xsl:sort select="*[name()=$sortby]"/>
					</xsl:apply-templates>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<!-- pet -->
	<xsl:template match="pet">
		<tr><xsl:apply-templates/></tr>
	</xsl:template>
	 
	<!-- name -->
	<xsl:template match="name">
		<td style="text-align: right"><xsl:value-of select="."/></td>
	</xsl:template>
	 
	<!-- age -->
	<xsl:template match="age">
		<td style="text-align: right"><xsl:value-of select="."/></td>
	</xsl:template>
	 
	<!-- type or color -->
	<xsl:template match="type | color">
		<td><xsl:value-of select="."/></td>
	</xsl:template>
	 	 
</xsl:stylesheet>