#!/bin/bash

# marcxml2marc.sh - batch convert marcxml to marc

# Eric Lease Morgan <emorgan@nd.edu>
# April 29, 2009 - first cut, see: http://forums.macosxhints.com/showthread.php?t=79189
# May 29, 2009 - converted to utf-8

# process each .marcxml file
for f in *.marcxml; do 

  if [ -f "$f" ]; then

    # do the work
    /usr/local/bin/yaz-marcdump -i marcxml -o marc "$f" >> temp.raw

  fi

done

# convert to utf-8
/usr/local/bin/yaz-marcdump -f MARC-8 -t UTF-8 -o marc -l 9=97 temp.raw > $1

# clean-up
rm temp.raw


